import 'package:dating_app/constants/constants.dart';
import 'package:dating_app/helpers/app_localizations.dart';
import 'package:dating_app/models/user_model.dart';
import 'package:flutter/material.dart';

class ShowMeDialog extends StatefulWidget {
  const ShowMeDialog({super.key});

  @override
  ShowMeDialogState createState() => ShowMeDialogState();
}

class ShowMeDialogState extends State<ShowMeDialog> {
  // Variables
  final Map<String, dynamic>? _userSettings = UserModel().user.userSettings;
  String _selectedOption = "";
  String _selectedOptionKey = "";
  late AppLocalizations _i18n;

  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
    // Variables
    final i18n = AppLocalizations.of(context);
    final String? showMe = _userSettings?[USER_SHOW_ME];
    // Check option
    if (showMe != null) {
      setState(() {
        _selectedOption = i18n.translate(showMe);
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    // Initialization
    _i18n = AppLocalizations.of(context);
    // Map options
    final Map<String, String> mapOptions = {
      "women": _i18n.translate("women"),
      "men": _i18n.translate("men"),
      "everyone": _i18n.translate("everyone"),
    };

    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8.0)),
      elevation: 3,
      child: _dialogContent(context, mapOptions),
    );
  }

  // Build dialog
  Widget _dialogContent(BuildContext context, Map<String, String> mapOptions) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: <Widget>[
        Padding(
          padding: const EdgeInsets.all(16),
          child: Row(
            children: <Widget>[
              const Icon(Icons.wc),
              const SizedBox(width: 5),
              Text(
                _i18n.translate("show_me"),
                style: const TextStyle(
                  fontWeight: FontWeight.bold,
                  fontSize: 20,
                ),
              ),
            ],
          ),
        ),
        const Divider(color: Colors.black, height: 5),
        Flexible(
          fit: FlexFit.loose,
          child: SingleChildScrollView(
            child: RadioGroup<String>(
              onChanged: (value) {
                setState(() {
                  _selectedOption = value.toString();
                  _selectedOptionKey = mapOptions.entries
                      .firstWhere((option) => option.value == value)
                      .key;
                });
                debugPrint(
                  'Selected option: $value, _selectedOptionKey: $_selectedOptionKey',
                );
              },
              groupValue: _selectedOption,
              child: Column(
                mainAxisSize: MainAxisSize.min,
                children: mapOptions.entries.map((option) {
                  return RadioListTile<String>(
                    selected: _selectedOption == option.value ? true : false,
                    title: Text(option.value),
                    activeColor: Theme.of(context).primaryColor,
                    value: option.value,
                  );
                }).toList(),
              ),
            ),
          ),
        ),
        const Divider(color: Colors.black, height: 5),
        Builder(
          builder: (context) {
            return Padding(
              padding: const EdgeInsets.all(5),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                children: <Widget>[
                  TextButton(
                    child: Text(_i18n.translate("CANCEL")),
                    onPressed: () {
                      Future(() => Navigator.of(context).pop());
                    },
                  ),
                  TextButton(
                    onPressed: _selectedOption == ''
                        ? null
                        : () async {
                            /// Save option
                            await UserModel().updateUserData(
                              userId: UserModel().user.userId,
                              data: {
                                '$USER_SETTINGS.$USER_SHOW_ME':
                                    _selectedOptionKey,
                              },
                            );

                            // Close dialog
                            Future(() => Navigator.of(context).pop());
                            debugPrint('Show me option() -> saved');
                          },
                    child: Text(
                      _i18n.translate("SAVE"),
                      style: TextStyle(color: Theme.of(context).primaryColor),
                    ),
                  ),
                ],
              ),
            );
          },
        ),
      ],
    );
  }
}
